import sys

import torch

sys.path.append("src")
from pruner.utils import find_layers


def random_importance(model, tokenizer, device=torch.device("cuda:0")):
    """
    Compute the weight importance of each layer in the model.
    """
    try:
        layers = model.model.layers
    except:
        layers = model.model.decoder.layers
    W_metrics = {}
    cnt = 0
    for i in range(len(layers)):
        layer = layers[i]
        subset = find_layers(layer)

        for name in subset:
            W = subset[name].weight.data
            W_metrics[cnt] = torch.rand_like(W)
            cnt += 1
    return W_metrics
